* Sensitivity analysis of preferred calculation
* Date last edited 2 October 2018
* File author: Mary-Alice Doyle

* Purpose: calcualtions for net benefit/cost of credit card holding, with 2-3 options per component 

********
* SUMMARY OF METHOD
********
quietly {
* COMPONENTS CALCULATED AS FOLLOWS
* REWARDS
* value of rewards = points earn rate * annual spend


* ANNUAL FEE
* = annual fee from Card features database (CFD) * waived/discounted indicator 
* assuming discount of 50 per cent if discounted - this rate based on range of first-year discounts from CFD

* INTEREST-FREE PERIOD
* alternative interest rate is from Nov 16 RBA table F05, using responses to q8f
* value of IFP = alternative interst rate * annual spend * share of interst-free period used
* where % of interest free period is based on ccrepay varriable in pre-diary questionnaire

* INTEREST PAID
* = Interest paid in most recent statement * frequency of payments (from ccrepay) 


* FIXED PARAMETERS
* Seasonal factor: 0.99 for October 2016 is based on RPS credit/charge card isuing personal purchases (from X12 output). 
* ^ The October SF is used because survey was conducted in November, but based on most recent monthly statement at that time

*Interest rates
* Standard variable home loan rate: 5.25 in Nov 2016
* Personal loan: 13.9 in Nov 2016
* Personal bonus online savings rate: 2.05 in Nov 2016
*------------------------------------------------
}

********
* SETUP
********
clear
set more off
cd [insert filepath for working directory]
do ".\Stata files\Setup.do"

drop if ccown==0
drop if ccmainfee>=1000
* ^ drop 13 respondents whose annual fee was above $1000. They mean bias net benefit estimates downwards by a lot, but these respondents likely accrue other, non-rewards-points benefits that are not included in these calculations (eg free flights or whatevs). 

********
* SET UP VARIABLES
********

* For step 1: Rewards
***************
* Annual spend based on monthly total
gen annualspend1 = (q7e / 0.99) * 12 if q7e>=0
* Annual spend based on diary week total
gen ccpayment = payamt if payamt>0 & (paymeth==3 | paymeth==4) & cc_used == ccmain
egen weeklyccspend = total(ccpayment), by(id)
gen annualspend2 = ((weeklyccspend * 30/7)/1.05) * 12

gen ccrebate1 = ccmainrebatepct
replace ccrebate1 = ccmain_flightrebate if q7a==3 & ccmain_flightrebate!=.
replace ccrebate1=0 if ccrebate1==-1
gen ccrebate2 = ccmainrebatepct
replace ccrebate2=0 if ccrebate1==-1
label var ccrebate1 "percent rewards rebate, based on redemption for flights for respondents who normally redeem for flights; $100 gift voucher for all other respondents"
label var ccrebate2 "percent rewards rebate, based on redemption for $100 gift voucher for all respondents"


* For step 2: Annual fee
***************
*Indicator for whether discounted/waived
gen annualfee_d = .
replace annualfee_d = 1 if ccown == 1
replace annualfee_d = 0 if q7d == 3 | q7d==4
replace annualfee_d = .5 if q7d == 2
label define annualfee_d 0 "waived (0)" 1 "everyone else - incl zero annual fee (1)"
label val annualfee_d annualfee_d

* $ value of annual fee
gen annualfee = annualfee_d * ccmainfee if ccmainfee!=-5 & ccmainfee!=-1
label var annualfee "$ value of annual fee paid, adjusted for waived/discounted"

* For step 3: Value of interest-free period
***************
gen ifp_used = .
replace ifp_used = 1 if ccrepay == 2
replace ifp_used = 0 if ccrepay == 4
replace ifp_used = 0 if ccrepay == 5
replace ifp_used = 30/ccmainday if ccrepay == 1 & ccmainday >=0
replace ifp_used = 0.6 if ccmainday==-5 & ccrepay==1
replace ifp_used = 15/ccmainday if ccrepay == 3 & ccmainday>=0
replace ifp_used = 0.25 if ccrepay == 3 & ccmainday==-5
replace ifp_used = 0.75 if ccrepay == 6

* Alternative interest rates
* Option 1: Detailed - some people who selected 1,2,5 probably also have an offset account, so this method may under-estimate value of IFP for those people. 
gen alt_ir1=.
replace alt_ir1 = 0.0525 if q8f == 3
replace alt_ir1 = 0.1390 if q8f == 4
replace alt_ir1 = 0.0205 if inlist(q8f,1,2,5)

* Option 2: Either personal loan or offset account (generous assumption, since only about 1/3 of Australians have a mortgage - the rest would be saving)
gen alt_ir2 = .
replace alt_ir2 = 0.1390 if q8f == 4
replace alt_ir2 = 0.0525 if inlist(q8f,1,2,5,3)

* Option 3: Simple: mortgage rate for everyone
gen alt_ir3=0.0525


* For step 4: Interest paid
******************
* Option 1: 3 options based on self-reported ccrepay
gen interest_freq1 = 0 if ccrepay>0
replace interest_freq1 = 1 if !inlist(ccrepay,5,6) & q7f>0
replace interest_freq1 = 3 if ccrepay==6
replace interest_freq1 = 12 if ccrepay==5

* Option 2: treat any payment as a one-off
gen interest_freq2 = 1 if q7f>0 & ccrepay>0
replace interest_freq2 = 0 if q7f<=0 & q7f>-5

gen interest_paid =0 if q7b!=-2 & q7b!=-1 & q7f!=-2 

* I create/replace the excel files here, so that they are created outside of the loop
quietly: tabout ccmainreward if idtag==1 & ccown==1 [aw=w1] using ".\Excel output\Sensitivity analysis - detailed descriptives.xls", f(4) c(col) replace  clab(rewardsshare)
quietly: tabout idtag if idtag==1 [aw=w1] using ".\Excel output\Sensitivity analysis - simple descriptives.xls", replace f(4) clab(annualfee) sum c(mean annualfee)
 
 
********
* CALCULATIONS
********
 
 * Loop through all combinations of options for the 4 components
forvalues i=1/3 {
	forvalues f=1/2{
	forvalues c=1/2 {
	forvalues j=1/2 {
		quietly {

		* Step 1
		******************
		gen rewards_annualval = 0
		replace rewards_annualval = ccrebate`c'/100* annualspend`j'  if annualspend`j'!=. & ccmainrebate>0
		replace rewards_annualval = . if annualspend`j'==. 
				
		* Step 2.5: Net value of payment function
		******************
		gen netpmtfunction = rewards_annualval - annualfee

		* Step 3: Interest-free period
		*******************
		* Value of interest free period - assuming balance is accrued in the middle of the month (day 15)
		gen ifp_potential = annualspend`j' * alt_ir`i' *(ccmainday-15)/365 if ccmainday >0
		label var ifp_potential "Value of IFP if respondent pays off on the due date"
		replace ifp_potential = 0 if ccmainday==0
		*^ There are two credit cards in the sample which do not have an interest-free period (interest applies immediately after purchase)
		
		gen ifp_value = ifp_potential * ifp_used
		label var ifp_value "Actual value of IFP based on reported fequency of cc repayments (from ccrepay)"
		
		* Step 4: Interest paid
		*********************
		replace interest_paid = q7f * interest_freq`f' if q7f>=0 & q7f!=.

		
		* Step 4.5: Net value of borrowing function
		********************
		gen netborrowingvalue = ifp_value - interest_paid
		* ^ we are missing data on 189 respondents - 18 per cent of cc holders (some we don't know maincc, 59 prefer not to answer credit card interst paid, 16 not sure/someone else looks after ccrepay, 129 prefer not to answer total card spend)

		* STEP 5: put everything together
		********
		gen netbenefit`j'`i'`c'`f' = netpmtfunction + netborrowingvalue
	
		* Indicator for gain, loss or neutral (where netural is -$50 to +$50)
		gen netdummy`j'`i'`c'`f' = 0 if netbenefit`j'`i'`c'`f'!=.
		replace netdummy`j'`i'`c'`f' = 1 if netbenefit`j'`i'`c'`f'>50 & netbenefit`j'`i'`c'`f'!=.
		replace netdummy`j'`i'`c'`f' = -1 if netbenefit`j'`i'`c'`f'<-50
		

		}
	* Output mean and median values of each component and of overall net benefit
	quietly: tabout idtag if idtag==1 & netbenefit`j'`i'`c'`f'!=. [aw=w1] using ".\Excel output\Sensitivity analysis - simple descriptives.xls", append f(4) clab(`j'`i'`c'`f') sum c(mean rewards_annualval mean annualfee mean ifp_value mean interest_paid mean netbenefit`j'`i'`c'`f')
	quietly: tabout idtag if idtag==1 & netbenefit`j'`i'`c'`f'!=. [aw=w1] using ".\Excel output\Sensitivity analysis - simple descriptives.xls", append f(4) clab(`j'`i'`c'`f') sum c(median rewards_annualval median annualfee median ifp_value median interest_paid median netbenefit`j'`i'`c'`f')
 
	drop rewards_annualval netpmtfunction ifp_potential ifp_value netborrowingvalue 
	}
	}
	}
	
**********
* Excel output - mean, median, standard deviation, interquartile range, count of observations
**********
* Monthly spend data - ifp varies - CC rebate incl flights - interest paid multiplied by 12/3/1 month
sum netbenefit1`i'11 if idtag==1 [aw=w1], detail
quietly: tabout idtag if idtag==1 & ccown==1 [aw=w1] using ".\Excel output\Sensitivity analysis - detailed descriptives.xls", append f(4) clab(monthly_if`i'_flights_mult) sum c(mean netbenefit1`i'11 median netbenefit1`i'11 sd netbenefit1`i'11 p25 netbenefit1`i'11 p75 netbenefit1`i'11 count netbenefit1`i'11)

tablecol netdummy1`i'11 idtag if idtag==1 [pw=w1], colpct nofreq
quietly: tabout idtag netdummy1`i'11 if idtag==1 & ccown==1 [aw=w1] using ".\Excel output\Sensitivity analysis - detailed descriptives.xls", append f(4) clab(monthly_if`i'_flights_mult) c(row)


* Weekly spend data - ifp varies - CC rebate incl flights - interest paid multiplied by 12/3/1 month
sum netbenefit2`i'11 if idtag==1 [aw=w1], detail
quietly: tabout idtag if idtag==1 & ccown==1 [aw=w1] using ".\Excel output\Sensitivity analysis - detailed descriptives.xls", append f(4) clab(weekly_if`i'_flights_mult) sum c(mean netbenefit2`i'11 median netbenefit2`i'11 sd netbenefit2`i'11 p25 netbenefit2`i'11 p75 netbenefit2`i'11 count netbenefit2`i'11)

tablecol netdummy2`i'11 idtag if idtag==1 [pw=w1], colpct nofreq
quietly: tabout idtag netdummy2`i'11 if idtag==1 & ccown==1 [aw=w1] using ".\Excel output\Sensitivity analysis - detailed descriptives.xls", append f(4) clab(weekly_if`i'_flights_mult) c(row)

* Monthly spend data - ifp varies - CC rebate $100 gift card only - interest paid multiplied by 12/3/1 month
sum netbenefit1`i'21 if idtag==1 [aw=w1], detail
quietly: tabout idtag if idtag==1 & ccown==1 [aw=w1] using ".\Excel output\Sensitivity analysis - detailed descriptives.xls", append f(4) clab(monthly_if`i'_giftcard_mult) sum c(mean netbenefit1`i'21 median netbenefit1`i'21 sd netbenefit1`i'21 p25 netbenefit1`i'21 p75 netbenefit1`i'21 count netbenefit1`i'21)

tablecol netdummy1`i'21 idtag if idtag==1 [pw=w1], colpct nofreq
quietly: tabout idtag netdummy1`i'21 if idtag==1 & ccown==1 [aw=w1] using ".\Excel output\Sensitivity analysis - detailed descriptives.xls", append f(4) clab(monthly_if`i'_giftcard_mult) c(row)

* Weekly spend data - ifp varies - CC rebate $100 gift card only - interest paid multiplied by 12/3/1 month
sum netbenefit2`i'21 if idtag==1 [aw=w1], detail
quietly: tabout idtag if idtag==1 & ccown==1 [aw=w1] using ".\Excel output\Sensitivity analysis - detailed descriptives.xls", append f(4) clab(weekly_if`i'_giftcard_mult) sum c(mean netbenefit2`i'21 median netbenefit2`i'21 sd netbenefit2`i'21 p25 netbenefit2`i'21 p75 netbenefit2`i'21 count netbenefit2`i'21)

tablecol netdummy2`i'21 idtag if idtag==1 [pw=w1], colpct nofreq
quietly: tabout idtag netdummy2`i'21 if idtag==1 & ccown==1 [aw=w1] using ".\Excel output\Sensitivity analysis - detailed descriptives.xls", append f(4) clab(weekly_if`i'_giftcard_mult) c(row)


* Monthly spend data - ifp varies - CC rebate incl flights -  interest paid treated as one-off
sum netbenefit1`i'12 if idtag==1 [aw=w1], detail
quietly: tabout idtag if idtag==1 & ccown==1 [aw=w1] using ".\Excel output\Sensitivity analysis - detailed descriptives.xls", append f(4) clab(monthly_if`i'_flights_oneoff) sum c(mean netbenefit1`i'12 median netbenefit1`i'12 sd netbenefit1`i'12 p25 netbenefit1`i'12 p75 netbenefit1`i'12 count netbenefit1`i'12)

tablecol netdummy1`i'12 idtag if idtag==1 [pw=w1], colpct nofreq
quietly: tabout idtag netdummy1`i'12 if idtag==1 & ccown==1 [aw=w1] using ".\Excel output\Sensitivity analysis - detailed descriptives.xls", append f(4) clab(monthly_if`i'_flights_oneoff) c(row)

* Weekly spend data - ifp varies - CC rebate incl flights -  interest paid treated as one-off
sum netbenefit2`i'12 if idtag==1 [aw=w1], detail
quietly: tabout idtag if idtag==1 & ccown==1 [aw=w1] using ".\Excel output\Sensitivity analysis - detailed descriptives.xls", append f(4) clab(weekly_if`i'_flights_oneoff) sum c(mean netbenefit2`i'12 median netbenefit2`i'12 sd netbenefit2`i'12 p25 netbenefit2`i'12 p75 netbenefit2`i'12 count netbenefit2`i'12)

tablecol netdummy2`i'12 idtag if idtag==1 [pw=w1], colpct nofreq
quietly: tabout idtag netdummy2`i'12 if idtag==1 & ccown==1 [aw=w1] using ".\Excel output\Sensitivity analysis - detailed descriptives.xls", append f(4) clab(weekly_if`i'_flights_oneoff) c(row)

* Monthly spend data - ifp varies - CC rebate $100 gift card only -  interest paid treated as one-off
sum netbenefit1`i'22 if idtag==1 [aw=w1], detail
quietly: tabout idtag if idtag==1 & ccown==1 [aw=w1] using ".\Excel output\Sensitivity analysis - detailed descriptives.xls", append f(4) clab(monthly_if`i'_giftcard_oneoff) sum c(mean netbenefit1`i'22 median netbenefit1`i'22 sd netbenefit1`i'22 p25 netbenefit1`i'22 p75 netbenefit1`i'22 count netbenefit1`i'22)

tablecol netdummy1`i'22 idtag if idtag==1 [pw=w1], colpct nofreq
quietly: tabout idtag netdummy1`i'22 if idtag==1 & ccown==1 [aw=w1] using ".\Excel output\Sensitivity analysis - detailed descriptives.xls", append f(4) clab(monthly_if`i'_giftcard_oneoff)  c(row)

* Weekly spend data - ifp varies - CC rebate $100 gift card only - interest paid treated as one-off
sum netbenefit2`i'22 if idtag==1 [aw=w1], detail
quietly: tabout idtag if idtag==1 & ccown==1 [aw=w1] using ".\Excel output\Sensitivity analysis - detailed descriptives.xls", append f(4) clab(weekly_if`i'_giftcard_oneoff) sum c(mean netbenefit2`i'22 median netbenefit2`i'22 sd netbenefit2`i'22 p25 netbenefit2`i'22 p75 netbenefit2`i'22 count netbenefit2`i'22)

tablecol netdummy2`i'22 idtag if idtag==1 [pw=w1], colpct nofreq
quietly: tabout idtag netdummy2`i'22 if idtag==1 & ccown==1 [aw=w1] using ".\Excel output\Sensitivity analysis - detailed descriptives.xls", append f(4) clab(weekly_if`i'_giftcard_oneoff) c(row)


}


